// File: tplot.h
//
// Description: This File contains the data structure/class
//              definition for the C++ TPlot class.
//
// Copyright 1992, 1994 by Mark Watson Associates
//
//       No binary rights reserved: this software library
//       may be used in compiled form without restrictions.
//       All source rights reserved: Source code to the GUI
//       library can not be distributed (on bulletin boards,
//       or as part of shareware or commercial products)
//       without written permission.
//

#ifndef tplot_h
#define tplot_h

#include "applib.h"

class TPlot {
 public:
    enum {MAX_PLOTS = 16};
    TPlot(TAppWindow *window, char *plot_title,
          double *x, double *y, int np,  int in_top,
          int in_right, int in_bottom, int in_left);
    TPlot(TAppWindow *window, char *plot_title,
          double *x, double **y, int number_of_plots,
          int np, int in_top, int in_right,
          int in_bottom, int in_left);
   ~TPlot();
    void rescale();
    void plot();
 private:
    // Pointer to the X coordinate data
    double *x_coord;
    // Pointers to the Y Coordinates for the plot(s)
    double *y_coords[MAX_PLOTS];
    // The number of points to plot
    int num_points;
    // The number of active plots:
    int num_plots;  // To a maximum of MAX_PLOTS.
    char *my_title;
    // Store the value of the pointer to the TAppWindow
    // containing this plot:
    TAppWindow *my_window;
    // Private plot data:
    int top, right, bottom, left;
    int x_org, y_org;
    double x_scale; // x_value * x_scale + x_org = 
                    //   x coordinate in my_window
    double y_scale; // y_value * y_scale + y_org =
                    //   y coordinate in my_window
    double x_min, y_min, x_max, y_max;
    // Calculate private scaling data:
    void calc_data(double x_min, double x_max,
                   double y_min, double y_max);
};

#endif tplot_h

